/* -*-c++-*- 
 * This source code is proprietary of ADIT
 * Copyright (C) 2013 Advanced Driver Information Technology Joint Venture GmbH
 * All rights reserved
 *
 * Author: Vadiraj Kaamsha <vadiraj.kaamsha@in.bosch.com>
 * Author: Rudolf Dederer <rudolf.dederer@de.bosch.com>
*/

#include <osgBatchedText/TextConfigBase>
#include <osgBatchedText/BatchElementBase>
#include <osgBatchedText/BatcherBase>

using namespace osgBatchedText;


BatcherConfigBase::BatcherConfigBase(BatchDrawableBase::tShaderType shaderType, int renderBin, int transpRenderBin, float transpFactor, const osg::Vec3& originOffset)
 : _renderBin(renderBin),
   _transpRenderBin(transpRenderBin),
   _transpFactor(transpFactor),
   _shaderType(shaderType),
   _originOffset(originOffset)
{
}

BatcherBase* BatcherConfigBase::getBatcher() const
{
   return _batcherBase.get();
}

void BatcherConfigBase::setBatcher(BatcherBase* batcherBase)
{
   if (!_batcherBase.valid())
   {
      _batcherBase = batcherBase;
   }
}

BatcherConfigBase::~BatcherConfigBase()
{
}

TextConfigBase::TextConfigBase(unsigned int fontSize, unsigned int outlineSize, float charSize, bool has_outline, float lineSpacing,
                               osgText::TextBase::AlignmentType alignmentType, BatchDrawableBase::tShaderType shaderType,
                               int renderBin, int transpRenderBin, float transpFactor)
 : BatcherConfigBase(shaderType, renderBin, transpRenderBin, transpFactor),
   _fontDescr(NULL, fontSize, outlineSize),
   _charSize(charSize),
   _lineSpacing(lineSpacing),
   _has_outline(has_outline),
   _alignmentType(alignmentType),
   _layout(osgText::TextBase::LEFT_TO_RIGHT)
{
}

